#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

int main() {
    long long N, M, K, L;
    std::cin >> N >> M >> K >> L;


    std::vector<std::vector<long long>> matrixA(N, std::vector<long long>(M));
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            std::cin >> matrixA[i][j];
        }
    }


    long long max = LLONG_MIN;
    int maxRowIndex = 0;
    int maxColIndex = 0;
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            if (matrixA[i][j] > max) {
                max = matrixA[i][j];
                maxRowIndex = i;
                maxColIndex = j;
            }
        }
    }

 
    long long tmp = matrixA[N / 2][M / 2];
    matrixA[N / 2][M / 2] = max;
    matrixA[maxRowIndex][maxColIndex] = tmp;

    
    std::vector<std::vector<long long>> sortedMatrix(N, std::vector<long long>(M));
    for (int i = 0; i < N; i++) {
        std::sort(matrixA[i].begin(), matrixA[i].end());
        int idx = M / 2;
        for (int j = 0; j < M; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % M];
        }
    }

   
    std::vector<std::vector<std::vector<long long>>> submatrices(N - K + 1,
                                                                std::vector<std::vector<long long>>(M - L + 1,
                                                                                                    std::vector<long long>(K * L)));
    for (int i = 0; i < N - K + 1; i++) {
        for (int j = 0; j < M - L + 1; j++) {
            for (int k = 0; k < K; k++) {
                for (int l = 0; l < L; l++) {
                    submatrices[i][j][k * L + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }

  
    long long totalSum = 0;
    for (int i = 0; i < N - K + 1; i++) {
        for (int j = 0; j < M - L + 1; j++) {
            for (int k = 0; k < K * L; k++) {
                totalSum += submatrices[i][j][k];
            }
        }
    }

    std::cout << totalSum << std::endl;

    return 0;
}